package com.liquidnet.service.adam.util;

import com.liquidnet.service.adam.dto.base.AdamCurrentUser;
import com.liquidnet.service.adam.entity.AdamUser;
import org.springframework.beans.BeanUtils;

import javax.servlet.http.HttpServletRequest;

public class CurrentUserUtil {

    private static final String userLoginTag = "current_user";

    public static AdamCurrentUser getCurrentUser(HttpServletRequest request) {
        return (AdamCurrentUser) request.getAttribute(userLoginTag);
    }

    public static void setCurrentUser(HttpServletRequest request, AdamUser adamUser) {
        AdamCurrentUser adamCurrentUser = new AdamCurrentUser();
        BeanUtils.copyProperties(adamUser, adamCurrentUser);
        request.setAttribute(userLoginTag, adamCurrentUser);
    }

    public static void setCurrentUser(HttpServletRequest request, AdamCurrentUser currentUser) {
        request.setAttribute(userLoginTag, currentUser);
    }

}

