package com.liquidnet.service.adam.util;

import com.liquidnet.service.adam.constant.AdamBaseEnum;
import org.apache.logging.log4j.util.Strings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 枚举工具类
 *
 * @author LiChen
 * @date 2020/9/17 2:47 下午
 */
public class EnumUtil {

    /**
     * 枚举list
     */
    public static List<Map<String, String>> getList(AdamBaseEnum[] enums) {
        List<Map<String, String>> list = new ArrayList<>();
        for (AdamBaseEnum e : enums) {
            Map<String, String> map = new HashMap<>();
            map.put("code", e.getCode());
            map.put("desc", e.getDesc());
            list.add(map);
        }
        return list;
    }

    /**
     * 根据code获取desc
     */
    public static String getDescByCode(AdamBaseEnum[] enums, String code) {
        if (code == null) {
            return "";
        }
        for (AdamBaseEnum e : enums) {
            if (code.equals(e.getCode())) {
                return e.getDesc();
            }
        }
        return "";
    }

    public static boolean isExist(AdamBaseEnum[] enums, String code) {
        if (code == null) {
            return false;
        }
        for (AdamBaseEnum e : enums) {
            if (code.equals(e.getCode())) {
                return true;
            }
        }
        return false;
    }

    public static <T extends AdamBaseEnum> T getEnumFromString(String enumString, T[] t) {
        if (Strings.isEmpty(enumString)) {
            return null;
        }

        if (!isExist(t, enumString)) {
            return null;
        }

        for (AdamBaseEnum e : t) {
            if (enumString.equals(e.getCode())) {
                return (T) e;
            }
        }
        return null;
    }

}
