package com.liquidnet.service.adam.vo;

import com.liquidnet.service.adam.entity.AdamAdminisProcessHis;
import com.liquidnet.service.adam.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "AdamAdminisProcessHisVo")
public class AdamAdminisProcessHisVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 8837945680992243189L;
    @ApiModelProperty(position = 11, required = true, value = "Processed history id [20]")
    private String hisId;
    @ApiModelProperty(position = 12, required = true, value = "Processed date")
    private String processedDateAt;
    @ApiModelProperty(position = 13, required = true, value = "Status [100]")
    private String status;
    @ApiModelProperty(position = 14, required = true, value = "Admin ID [64]")
    private String adminId;
    @ApiModelProperty(position = 15, required = true, value = "Admin name [200]")
    private String adminName;

    private static final AdamAdminisProcessHisVo obj = new AdamAdminisProcessHisVo();

    public static AdamAdminisProcessHisVo getNew() {
        try {
            return (AdamAdminisProcessHisVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamAdminisProcessHisVo();
    }

    public AdamAdminisProcessHisVo copy(AdamAdminisProcessHis source) {
        this.setHisId(String.valueOf(source.getHisId()));
        this.setProcessedDateAt(DateUtil.getVoTimestamp(source.getOperatTime()));
        this.setStatus(source.getHisVal());
        this.setAdminId(source.getOperator());
        this.setAdminName(source.getOperatorName());
        return this;
    }
}
