package com.liquidnet.service.adam.vo;

import com.liquidnet.service.adam.entity.AdamAccountWallet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "AdamAdminisWalletVo", description = "Results of wallet list")
public class AdamAdminisWalletVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -6516399671028825500L;
    @ApiModelProperty(position = 11, required = true, value = "Wallet access executor [1-Executable,2-Not Executable]")
    private String accessExecutor;
    @ApiModelProperty(position = 12, required = true, value = "Wallet number [64]")
    private String walletNo;
    @ApiModelProperty(position = 13, required = true, value = "Wallet currency [10]")
    private String currency;
    @ApiModelProperty(position = 14, required = true, value = "Wallet nick name [50]")
    private String nickName;

    private static final AdamAdminisWalletVo obj = new AdamAdminisWalletVo();

    public static AdamAdminisWalletVo getNew() {
        try {
            return (AdamAdminisWalletVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamAdminisWalletVo();
    }

    public AdamAdminisWalletVo copy(AdamAccountWallet source) {
        this.setWalletNo(source.getFinWalletNo());
        this.setCurrency(source.getCurrency());
        this.setNickName(source.getName());
        return this;
    }
}
