package com.liquidnet.service.adam.vo;

import com.liquidnet.service.adam.entity.AdamSysCountry;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 公司枚举参数
 *
 * @author LiChen
 * @date 2020/9/17 5:27 下午
 */
@Data
@ApiModel(description = "公司枚举参数")
public class AdamComEnumVo {
    @ApiModelProperty(value = "公司类型列表", position = 10)
    private List<Map<String, String>> comTypeList;

    @ApiModelProperty(value = "公司实体结构列表", position = 20)
    private List<Map<String, String>> comEntityStructureList;

    @ApiModelProperty(value = "公司行业类别列表", position = 30)
    private List<Map<String, String>> comIndustryCategoryList;

    @ApiModelProperty(value = "身份类型列表", position = 35)
    private List<Map<String, String>> IdTypeList;

    @ApiModelProperty(value = "国家代码/电话代码列表", position = 40)
    private List<AdamSysCountry> sysCountryList;

    @ApiModelProperty(value = "预计交易量列表", position = 50)
    private List<Map<String, String>> comExpectedTransactionList;

    @ApiModelProperty(value = "公司使用Liquidnet用途", position = 60)
    private List<Map<String, String>> comLiquidnetUseList;

}
