package com.liquidnet.service.adam.vo;

import com.liquidnet.service.adam.constant.AdamConversionConstants;
import com.liquidnet.service.adam.constant.AdamTransactionConstants;
import com.liquidnet.service.adam.entity.AdamConversion;
import com.liquidnet.service.adam.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

@Data
@ApiModel
public class AdamConversionVo extends AdamConversion {

    @ApiModelProperty("交易类型描述")
    private String transactionTypeDesc;

    @ApiModelProperty("状态描述")
    private String statusDesc;

    @ApiModelProperty("时间戳")
    private String createTimeAt;

    @ApiModelProperty("时间戳")
    private String conversionDateAt;

    @ApiModelProperty("时间戳")
    private String settlementDateAt;

    public void conversion(AdamConversion r) {
        if (r == null) {
            return;
        }

        BeanUtils.copyProperties(r, this);

        this.setConversionDateAt(DateUtil.getVoTimestamp(r.getConversionDate()));
        this.setSettlementDateAt(DateUtil.getVoTimestamp(r.getConversionDate()));
        this.setCreateTimeAt(DateUtil.getVoTimestamp(r.getConversionDate()));

        AdamConversionConstants.StatusEnum statusEnum = AdamConversionConstants.StatusEnum.getEnumByCode(r.getStatus());
        this.setStatusDesc(statusEnum != null ? statusEnum.getDesc() : "");
        this.setTransactionTypeDesc(AdamTransactionConstants.TypeEnum.FX_CONVERSION.getDesc());
    }

}
