package com.liquidnet.service.adam.vo;

import com.liquidnet.service.adam.constant.AdamPayerConstants;
import com.liquidnet.service.adam.entity.AdamPayer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

@Data
@ApiModel()
public class AdamPayerVo extends AdamPayer {


    @ApiModelProperty(value = "类型描述")
    private String typeDesc;


    public void conversion(AdamPayer r) {
        if (r == null) {
            return;
        }
        BeanUtils.copyProperties(r, this);
        AdamPayerConstants.LegalEntityTypeEnum typeEnum = AdamPayerConstants.LegalEntityTypeEnum.getEnumByCode(r.getLegalEntityType());
        this.setTypeDesc(typeEnum != null ? typeEnum.getDesc() : null);

    }

}
