package com.liquidnet.service.adam.vo;

import com.liquidnet.service.adam.entity.AdamPayoutBeneficiary;
import com.liquidnet.service.adam.entity.AdamPayoutPayer;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.time.LocalDateTime;

@Data
@ApiModel()
public class AdamPayoutBeneficiaryVo {

    private String id;

    private String legalEntityType;

    private String existing;

    private String currency;

    private String nickName;

    private String firstName;

    private String lastName;

    private String fullName;

    private String country;

    private String address;

    private String city;

    private String postCode;

    private String province;

    private String bankCountry;

    private String bankAccountNo;

    private String paymentMethod;

    private String paymentMethodDetail;

    private String paymentMethodUse;

    private LocalDateTime createTime;

    private LocalDateTime updateTime;

    public void conversion(AdamPayoutBeneficiary r) {
        if (r == null) {
            return;
        }
        BeanUtils.copyProperties(r, this);

    }

}
