package com.liquidnet.service.adam.vo;

import com.liquidnet.service.adam.constant.AdamPayoutConstants;
import com.liquidnet.service.adam.constant.AdamTransactionConstants;
import com.liquidnet.service.adam.entity.AdamPayout;
import com.liquidnet.service.adam.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

@Data
@ApiModel()
public class AdamPayoutVo extends AdamPayout {

    @ApiModelProperty("执行下发时间,时间戳")
    private String executionDateAt;

    @ApiModelProperty("创建时间,时间戳")
    private String createTimeAt;

    @ApiModelProperty("状态描述")
    private String statusDesc;

    @ApiModelProperty("交易类型描述")
    private String transactionTypeDesc;

    @ApiModelProperty("交易id")
    private String transactionId;

    public void conversion(AdamPayout r) {
        if (r == null) {
            return;
        }
        BeanUtils.copyProperties(r, this);

        this.setExecutionDateAt(DateUtil.getVoTimestamp(r.getExecutionDate()));
        this.setCreateTimeAt(DateUtil.getVoTimestamp(r.getCreateTime()));
        AdamPayoutConstants.StatusEnum statusEnum = AdamPayoutConstants.StatusEnum.getEnumByCode(r.getStatus());
        this.setStatusDesc(statusEnum != null ? statusEnum.getDesc() : null);
        this.setTransactionTypeDesc(AdamTransactionConstants.TypeEnum.PAYOUT.getDesc());
    }

}
