package com.liquidnet.service.adam.vo;

import com.liquidnet.service.adam.entity.AdamRolePermission;
import com.liquidnet.service.adam.entity.AdamUserPermission;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "AdamPermissionInfoVo", description = "Info of permission")
public class AdamPermissionInfoVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -4112332435672404860L;
    @ApiModelProperty(position = 11, required = true, value = "Role ID [32]")
    private String roleId;
    @ApiModelProperty(position = 12, required = true, value = "Auth key [32]")
    private String authId;
    @ApiModelProperty(position = 13, required = true, value = "Can it be executed [0-non,1-true,2-false]")
    private String executable;
    @ApiModelProperty(position = 14, required = true, value = "Can edit [1-true,2-false]")
    private String editable;

    private static final AdamPermissionInfoVo obj = new AdamPermissionInfoVo();

    public static AdamPermissionInfoVo getNew() {
        try {
            return (AdamPermissionInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamPermissionInfoVo();
    }

    public AdamPermissionInfoVo copy(AdamUserPermission source) {
        this.setRoleId(source.getRoleId());
        this.setAuthId(source.getAuthId());
        this.setExecutable(source.getExecutable());
        this.setEditable(source.getEditable());
        return this;
    }

    public AdamPermissionInfoVo copy(AdamRolePermission source) {
        this.setRoleId(source.getRoleId());
        this.setAuthId(source.getAuthId());
        this.setExecutable(source.getExecutable());
        this.setEditable(source.getEditable());
        return this;
    }
}
