package com.liquidnet.service.adam.vo;

import com.liquidnet.service.adam.constant.AdamTransactionConstants;
import com.liquidnet.service.adam.entity.AdamTransaction;
import com.liquidnet.service.adam.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel
public class AdamTransactionVo  implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    private String id;

    @ApiModelProperty(value = "transaction number")
    private String number;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "类型描述")
    private String typeDesc;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty("状态描述")
    private String statusDesc;

    @ApiModelProperty("币种")
    private String currency;

    @ApiModelProperty("出入账金额")
    private BigDecimal fundAmount;

    @ApiModelProperty("出入账类型,C=Credit(+),D=Debit(-)")
    private String fundDirection;

    @ApiModelProperty("关联订单id")
    private String relatedId;

    @ApiModelProperty("关联订单备注")
    private String relatedReference;

    @ApiModelProperty("钱包账号")
    private String finWalletNo;

    @ApiModelProperty("钱包名称")
    private String finWalletName;


    @ApiModelProperty("钱包交易id")
    private String finWalletTransactionId;

    @ApiModelProperty("钱包可用余额")
    private BigDecimal finWalletAvailableBalance;

    @ApiModelProperty("钱包总余额")
    private BigDecimal finWalletTotalBalance;

    @ApiModelProperty("创建时间,时间戳")
    private String createTimeAt;

    @ApiModelProperty("完成时间,时间戳")
    private String completeTimeAt;

    public void conversion(AdamTransaction r) {
        if (r == null) {
            return;
        }
        BeanUtils.copyProperties(r, this);
        AdamTransactionConstants.StatusEnum statusEnum = AdamTransactionConstants.StatusEnum.getEnumByCode(r.getStatus());
        AdamTransactionConstants.TypeEnum typeEnum = AdamTransactionConstants.TypeEnum.getEnumByCode(r.getType());
        this.setStatusDesc(statusEnum != null ? statusEnum.getDesc() : null);
        this.setTypeDesc(typeEnum != null ? typeEnum.getDesc() : null);

        this.setCreateTimeAt(DateUtil.getVoTimestamp(r.getCreateTime()));
        this.setCompleteTimeAt(DateUtil.getVoTimestamp(r.getCompleteTime()));

    }

}
