package com.liquidnet.service.adam.vo;

import com.liquidnet.service.adam.constant.AdamUserConstants;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "AdamUserAdminisListVo", description = "Results of user administration list")
public class AdamUserAdminisListVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -5059659872883746123L;
    @ApiModelProperty(position = 11, required = true, value = "User ID [64]")
    private String userId;
    @ApiModelProperty(position = 12, required = true, value = "User first name [99]")
    private String firstName;
    @ApiModelProperty(position = 13, required = true, value = "User last name [99]")
    private String lastName;
    @ApiModelProperty(position = 14, required = true, value = "User job title [99]")
    private String jobTitle;
    @ApiModelProperty(position = 15, required = true, value = "User email [99]")
    private String companyEmail;
    @ApiModelProperty(position = 16, required = true, value = "User role [32]")
    private String userRole;
    @ApiModelProperty(position = 17, required = true, value = "User status [32]")
    private String status;
    @ApiModelProperty(position = 18, required = true, value = "User created time")
    private String createdDateAt;
    @ApiModelProperty(position = 19, required = true, value = "User latest update time")
    private String latestUpdateDateAt;

    private static final AdamUserAdminisListVo obj = new AdamUserAdminisListVo();

    public static AdamUserAdminisListVo getNew() {
        try {
            return (AdamUserAdminisListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamUserAdminisListVo();
    }

    public AdamUserAdminisListVo copy(AdamUser source) {
        this.setUserId(source.getId());
        this.setFirstName(source.getFirstName());
        this.setLastName(source.getLastName());
        this.setJobTitle(source.getJobTitle());
        this.setCompanyEmail(source.getEmail());
        this.setUserRole(source.getRole());
        this.setStatus(AdamUserConstants.UserStatusEnum.byCode(source.getStatus()).getDesc());
        this.setCreatedDateAt(DateUtil.getVoTimestamp(source.getCreateTime()));
        this.setLatestUpdateDateAt(DateUtil.getVoTimestamp(source.getUpdateTime()));
        return this;
    }
}
