package com.liquidnet.service.adam.vo;

import com.liquidnet.service.adam.constant.AdamUserConstants;
import com.liquidnet.service.adam.entity.AdamUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;

@Data
@ApiModel(value = "AdamUserProfileVo", description = "Results of user profile details")
public class AdamUserProfileVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 1118362487875951397L;
    @ApiModelProperty(position = 11, required = true, value = "User ID [64]")
    private String userId;
    @ApiModelProperty(position = 12, required = true, value = "User first name [99]")
    private String firstName;
    @ApiModelProperty(position = 13, required = true, value = "User last name [99]")
    private String lastName;
    @ApiModelProperty(position = 14, required = true, value = "User job title [99]")
    private String jobTitle;
    @ApiModelProperty(position = 15, required = true, value = "User phone area code [10]")
    private String phoneCode;
    @ApiModelProperty(position = 16, required = true, value = "User phone number [20]")
    private String phoneNumber;
    @ApiModelProperty(position = 17, required = true, value = "User phone number certification status [1-Certified,2-NotCertified]")
    private String phoneNumberStatus;
    @ApiModelProperty(position = 18, required = true, value = "User email [99]")
    private String companyEmail;
    @ApiModelProperty(position = 19, required = true, value = "User email active state [1-Activated,2-NotActivated]")
    private String companyEmailStatus;
    @ApiModelProperty(position = 20, required = true, value = "User role [32]")
    private String userRole;
    @ApiModelProperty(position = 21, required = true, value = "User permissions [List]")
    private List<AdamPermissionInfoVo> userPermissions;
    @ApiModelProperty(position = 22, required = true, value = "User accessible wallets [List]")
    private List<AdamAdminisWalletVo> userAllowedWallets;
    @ApiModelProperty(position = 23, required = true, value = "Adminis process history [List]")
    private List<AdamAdminisProcessHisVo> processHis;
    @ApiModelProperty(position = 24, required = true, value = "User role permissions [Map]")
    private Map<String, List<AdamPermissionInfoVo>> rolePermissionsMap;
    @ApiModelProperty(position = 25, required = true, value = "User role list [Map]")
    private Map<String, String> roleMap;
    @ApiModelProperty(position = 26, required = true, value = "User status [32]")
    private String status;

    private static final AdamUserProfileVo obj = new AdamUserProfileVo();

    public static AdamUserProfileVo getNew() {
        try {
            return (AdamUserProfileVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamUserProfileVo();
    }

    public AdamUserProfileVo copy(AdamUser source) {
        this.setUserId(source.getId());
        this.setFirstName(source.getFirstName());
        this.setLastName(source.getLastName());
        this.setJobTitle(source.getJobTitle());
        this.setPhoneCode(source.getPhoneCode());
        this.setPhoneNumber(source.getPhoneNumber());
        this.setPhoneNumberStatus(StringUtils.isEmpty(this.getPhoneNumber()) ? "2" : "1");
        this.setCompanyEmail(source.getEmail());
        this.setCompanyEmailStatus(StringUtils.isEmpty(source.getPassword()) ? "2" : "1");
        this.setUserRole(source.getRole());
        this.setStatus(AdamUserConstants.UserStatusEnum.byCode(source.getStatus()).getDesc());
        return this;
    }
}
