package com.liquidnet.service.adam.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "AdamUserVo", description = "Details of user")
public class AdamUserVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 2934012136019631554L;
    @ApiModelProperty(position = 11, required = true, value = "User ID [64]")
    private String userId;
    @ApiModelProperty(position = 12, required = true, value = "User first name [99]")
    private String firstName;
    @ApiModelProperty(position = 13, required = true, value = "User last name [99]")
    private String lastName;
    @ApiModelProperty(position = 14, required = true, value = "User company email [99]")
    private String companyEmail;

    private static final AdamUserVo obj = new AdamUserVo();

    public static AdamUserVo getNew() {
        try {
            return (AdamUserVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamUserVo();
    }
}
