package com.liquidnet.service.adam.vo;

import com.liquidnet.service.adam.entity.AdamAccountWallet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(value = "AdamWalletAccessVo", description = "Details of wallet access")
public class AdamWalletAccessVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = -778366272456804602L;
    @ApiModelProperty(position = 11, required = true, value = "Wallet number [64]")
    private String walletNo;
    @ApiModelProperty(position = 12, required = true, value = "Wallet currency [10]")
    private String currency;
    @ApiModelProperty(position = 13, required = true, value = "Wallet nick name [50]")
    private String nickName;
    @ApiModelProperty(position = 14, required = true, value = "Users allowed to access the wallet [List]")
    private List<AdamUserVo> allowedUserList;

    private static final AdamWalletAccessVo obj = new AdamWalletAccessVo();

    public static AdamWalletAccessVo getNew() {
        try {
            return (AdamWalletAccessVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamWalletAccessVo();
    }

    public AdamWalletAccessVo copy(AdamAccountWallet source) {
        this.setWalletNo(source.getFinWalletNo());
        this.setCurrency(source.getCurrency());
        this.setNickName(source.getName());
        return this;
    }
}
