package com.liquidnet.service.adam.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 账户钱包
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamAccountWallet implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 账户id
     */
    private String accountId;

    /**
     * com id
     */
    private String comId;

    /**
     * 币种
     */
    private String currency;

    /**
     * 钱包名称
     */
    private String name;

    /**
     * 状态
     */
    private String state;

    /**
     * 资金钱包no
     */
    private String finWalletNo;

    /**
     * 银行钱包id
     */
    private String bankWalletId;

    private String bankChannel;

    private LocalDateTime deleteDate;

    private LocalDateTime createTime;

    private LocalDateTime updateTime;

}
