package com.liquidnet.service.adam.entity;

import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 收款人信息
 * </p>
 *
 * @author liquidnet
 * @since 2020-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamBeneficiary implements Serializable {

    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * 公司id
     */
    private String comId;

    /**
     * 类型：个人，公司
     */
    private String legalEntityType;

    /**
     * 状态
     */
    private String status;

    private String currency;

    private String nickName;

    private String firstName;

    private String lastName;

    private String fullName;

    private String address;

    private String country;

    private String city;

    private String postCode;

    private String province;

    private String bankCountry;

    private String bankAccountNo;

    private String paymentMethod;

    private String paymentMethodDetail;

    private LocalDateTime deleteTime;

    private LocalDateTime createTime;

    private LocalDateTime updateTime;


}
