package com.liquidnet.service.adam.entity;

import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 公司信息
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamComInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 公司名称
     */
    private String name;

    /**
     * 状态
     */
    private String state;

    /**
     * 类型
     */
    private String type;

    /**
     * 类型-其他
     */
    private String typeOther;

    /**
     * 持股25%以上的数量
     */
    private String stakeNumber;

    /**
     * 注册国家代码
     */
    private String registrationCountryCode;

    /**
     * 注册号
     */
    private String registrationNumber;

    /**
     * 网址
     */
    private String websiteUrl;

    /**
     * 实体结构
     */
    private String entityStructure;

    /**
     * 营业年限
     */
    private String businessYears;

    /**
     * 行业类别
     */
    private String industryCategory;

    /**
     * 行业类别-其他
     */
    private String industryCategoryOther;

    /**
     * 电话-国家/地区代码
     */
    private String phoneCode;

    /**
     * 电话号码
     */
    private String phoneNumber;

    /**
     * 国家
     */
    private String addressCountry;

    /**
     * 州/省
     */
    private String addressProvince;

    /**
     * 城市
     */
    private String addressCity;

    /**
     * 街道
     */
    private String addressStreet;

    /**
     * 邮编
     */
    private String addressPostCode;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
