package com.liquidnet.service.adam.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 公司法人
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamComLegalPerson implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private String id;

    private String comId;

    /**
     * 全名
     */
    private String fullName;

    /**
     * 出生日期
     */
    private String dateBirth;

    /**
     * 电话代码
     */
    private String phoneCode;

    /**
     * 电话号码
     */
    private String phoneNumber;

    /**
     * 邮件地址
     */
    private String email;

    /**
     * id签发国家/地区代码
     */
    private String idCountryCode;

    /**
     * 类型
     */
    private String idType;

    /**
     * id号
     */
    private String idNumber;

    /**
     * id文件证明
     */
    private String idProof;

    /**
     * 国家
     */
    private String addressCountry;

    /**
     * 州/省
     */
    private String addressProvince;

    /**
     * 城市
     */
    private String addressCity;

    /**
     * 街道
     */
    private String addressStreet;

    /**
     * 邮编
     */
    private String addressPostCode;

    /**
     * 住宅文件证明
     */
    private String addressProof;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
