package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = false)
public class AdamComProfile implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    private String comId;

    private String item;

    private String itemVal;

    private String itemDesc;

    private LocalDateTime createTime;

    private String createBy;

    private LocalDateTime updateTime;

    private String updateBy;

    private static final AdamComProfile obj = new AdamComProfile();

    public static AdamComProfile getNew() {
        try {
            return (AdamComProfile) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamComProfile();
    }

    public AdamComProfile init(String comId, String item, String itemVal, String itemDesc) {
        this.setComId(comId);
        this.setItem(item);
        this.setItemVal(itemVal);
        this.setItemDesc(itemDesc);
        this.setCreateTime(LocalDateTime.now());
        this.setCreateBy("system.init");
        return this;
    }
}
