package com.liquidnet.service.adam.entity;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 公司股东信息
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamComShareholder implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 公司id
     */
    private String comId;

    /**
     * 职位
     */
    private String position;

    /**
     * 全名
     */
    private String fullName;

    /**
     * 出生日期
     */
    private String dateBirth;

    /**
     * id颁发国家代码
     */
    private String idCountryCode;

    /**
     * 住宅地址
     */
    private String residentialAddress;

    /**
     * id文件证明
     */
    private String idProof;

    /**
     * 住宅文件证明
     */
    private String addressProof;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
