package com.liquidnet.service.adam.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 换汇
 * </p>
 *
 * @author liquidnet
 * @since 2020-11-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamConversion implements Serializable {

    private static final long serialVersionUID = 1L;

    private String id;

    private String comId;

    private String userId;

    private String status;

    private String fromWalletNo;

    private String toWalletNo;

    private BigDecimal sellAmount;

    private String sellCurrency;

    private String buyCurrency;

    private BigDecimal buyAmount;

    private String fixedSide;

    private BigDecimal quoteRate;

    private BigDecimal executionRate;

    private LocalDateTime conversionDate;

    private LocalDateTime settlementDate;

    private String bankChannel;

    private String bankConversionId;

    private String failureReason;

    private LocalDateTime createTime;

    private LocalDateTime updateTime;

    private LocalDateTime completeTime;

}
