package com.liquidnet.service.adam.entity;

import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 注册国家关联文件表
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamCountryFileLink implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private String id;

    /**
     * 国家代码
     */
    private String countryCode;

    /**
     * 文件id
     */
    private String fileId;

    /**
     * 文件别名
     */
    private String fileAliasTitle;

    /**
     * 文件排序
     */
    private Integer sort;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
