package com.liquidnet.service.adam.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 充值信息表
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamFunding implements Serializable {

    private static final long serialVersionUID = 1L;

    private String id;

    private String finWalletNo;

    private String comId;

    /**
     * 状态
     */
    private String status;

    /**
     * 币种
     */
    private String currency;

    /**
     * 金额
     */
    private BigDecimal amount;

    private String reference;

    private String reason;

    /**
     * 银行id
     */
    private String bankFundingId;

    /**
     * 银行渠道
     */
    private String bankChannel;

    /**
     * 完成时间
     */
    private LocalDateTime completeTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
