package com.liquidnet.service.adam.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 在线用户记录
 * </p>
 *
 * @author liquidnet
 * @since 2020-11-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamLoginOnline implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 用户会话id
     */
    private String sessionId;

    /**
     * 公司id
     */
    private String comId;

    /**
     * 账号
     */
    private String accountNo;

    /**
     * 手机号
     */
    private String telephone;

    /**
     * 登录IP地址
     */
    private String ipaddr;

    /**
     * 登录地点
     */
    private String loginLocation;

    /**
     * 浏览器类型
     */
    private String browser;

    /**
     * 操作系统
     */
    private String os;

    /**
     * 在线状态on_line在线off_line离线
     */
    private String status;

    /**
     * session创建时间
     */
    private LocalDateTime startTimestamp;

    /**
     * session最后访问时间
     */
    private LocalDateTime lastAccessTime;

    /**
     * 超时时间，单位为秒
     */
    private Integer expireTime;


}
