package com.liquidnet.service.adam.entity;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 下发信息
 * </p>
 *
 * @author liquidnet
 * @since 2020-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamPayout implements Serializable {

    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * fin wallet no
     */
    private String finWalletNo;

    private String comId;

    private String userId;

    private String status;

    /**
     * 币种
     */
    private String currency;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 参考信息
     */
    private String reference;

    /**
     * 原因目的
     */
    private String reason;

    private String bankPayoutId;

    private String bankChannel;

    /**
     * 执行日期
     */
    private LocalDate executionDate;

    private String fxWith;

    private String fxContractNo;

    private String fxQuote;

    private String failureReason;

    /**
     * 即期远期
     */
    private String spotForward;


    private LocalDateTime completeTime;

    private LocalDateTime createTime;

    private LocalDateTime updateTime;

}
