package com.liquidnet.service.adam.entity;

import java.time.LocalDateTime;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 国家表
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamSysCountry implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 国家代码二位
     */
    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 电话代码
     */
    private String phoneCode;

    /**
     * 币种名称
     */
    private String currencyName;

    /**
     * 币种字母代码
     */
    private String currencyAlphabeticCode;

    /**
     * 币种数字代码
     */
    private String currencyNumericCode;

    /**
     * 币种精度
     */
    private String currencyMinorUnit;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
