package com.liquidnet.service.adam.entity;

import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = false)
public class AdamUserPermission implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    private String userId;

    private String comId;

    private String roleId;

    private String authId;

    /**
     * 0-non_executable,1-true,2-false
     */
    private String executable;

    /**
     * 1-true,2-false
     */
    private String editable;

    private static final AdamUserPermission obj = new AdamUserPermission();

    public static AdamUserPermission getNew() {
        try {
            return (AdamUserPermission) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamUserPermission();
    }

    public AdamUserPermission copy(AdamRolePermission source) {
        this.setAuthId(source.getAuthId());
        this.setExecutable(source.getExecutable());
        this.setEditable(source.getEditable());
        return this;
    }
}
