-- ----------------------------
-- Function structure for _currval
-- ----------------------------
use `liquidnet_adam`;

DROP FUNCTION IF EXISTS `_currval`;
delimiter ;;
CREATE FUNCTION `_currval`(sn varchar(50))
 RETURNS mediumtext CHARSET utf8mb4 COLLATE utf8mb4_unicode_ci
begin
    declare current long;
    set current = 0;
    select current_val
    into current
    from sys_sequence
    where seq_name = sn;
    return current;
end
;;
delimiter ;

-- ----------------------------
-- Function structure for _nextval
-- ----------------------------
DROP FUNCTION IF EXISTS `_nextval`;
delimiter ;;
CREATE FUNCTION `_nextval`(sn varchar(50))
 RETURNS mediumtext CHARSET utf8mb4 COLLATE utf8mb4_unicode_ci
begin
    update LIQUIDNET_ADAM.sys_sequence
    set current_val = current_val + increment
    where seq_name = sn;
    return LIQUIDNET_ADAM._currval(sn);
end
;;
delimiter ;

-- ----------------------------
-- Function structure for _setval
-- ----------------------------
DROP FUNCTION IF EXISTS `_setval`;
delimiter ;;
CREATE FUNCTION `_setval`(sn varchar(50), value mediumtext)
 RETURNS mediumtext CHARSET utf8mb4 COLLATE utf8mb4_unicode_ci
begin
    update LIQUIDNET_ADAM.sys_sequence
    set current_val = value
    where seq_name = sn;
    return LIQUIDNET_ADAM._currval(sn);
end
;;
delimiter ;

SET FOREIGN_KEY_CHECKS = 1;