package com.liquidnet.service.adam.config;

import com.liquidnet.service.adam.interceptor.LoginInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;


@Configuration
public class AdamWebMvcConfig extends WebMvcConfigurationSupport {

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/**").addResourceLocations(
                "classpath:/static/");
        registry.addResourceHandler("doc.html").addResourceLocations(
                "classpath:/META-INF/resources/");
        registry.addResourceHandler("/webjars/**").addResourceLocations(
                "classpath:/META-INF/resources/webjars/");
        registry.addResourceHandler("*.js").addResourceLocations(
                "/webapp/js/**");
        registry.addResourceHandler("*.css").addResourceLocations(
                "webapp/css/**");
        registry.addResourceHandler("*.img").addResourceLocations(
                "webapp/img/**");
        super.addResourceHandlers(registry);
    }

    /**
     * 在这里添加Bean 来解决拦截类内部bean注入问题
     * @return
     */
    @Bean
    LoginInterceptor loginInterceptor(){
        return new LoginInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry){
        registry.addInterceptor(loginInterceptor())
                .excludePathPatterns("/actuator/refresh")
                .excludePathPatterns("/swagger-resources/**");
        super.addInterceptors(registry);
    }

}
