package com.liquidnet.service.adam.config;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description:
 * @class: MongoSSL
 * @Package com.liquidnet.service.adam.config
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/12/18 11:51 上午
 */
import com.mongodb.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;

import java.util.Collections;
import java.util.List;

//mongoSSl连接配置类
@Slf4j
@Configuration
public class MongoSslConfig {
    @Value("${spring.data.mongodb.trustStore}")
    private String trustStore;
    @Value("${spring.data.mongodb.trustStorePassword}")
    private String trustStorePassword;
    @Value("${spring.data.mongodb.uri}")
    private String mongodbUri;
    @Value("${spring.data.mongodb.sslEnabled}")
    private boolean sslEnabled;

//    @Bean
//    public GridFsTemplate gridFsTemplate(MongoDbFactory dbFactory, MongoConverter converter) {
//
//        System.setProperty("javax.net.ssl.trustStore",trustStore);
//        System.setProperty("javax.net.ssl.trustStorePassword",trustStorePassword);
//        return new GridFsTemplate(dbFactory, converter, "fs0");
//    }

    @Bean
    public MongoClient createMongoClientByUri() {
        log.info("MongoSslConfig trustStore:{}",trustStore);
        log.info("MongoSslConfig trustStorePassword:{}",trustStorePassword);
        log.info("MongoSslConfig mongodbUri:{}",mongodbUri);
        log.info("MongoSslConfig sslEnabled:{}",sslEnabled);

        System.setProperty("javax.net.ssl.trustStore",trustStore);
        System.setProperty("javax.net.ssl.trustStorePassword",trustStorePassword);

        MongoClientURI uri = new MongoClientURI(mongodbUri,MongoClientOptions.builder().sslEnabled(sslEnabled));
        return new MongoClient(uri);
    }

//    @Bean
//    public MongoClient createNetworkMongoClient() {
//        log.info("MongoSslConfig trustStore",trustStore);
//        log.info("MongoSslConfig trustStorePassword",trustStorePassword);
//        log.info("MongoSslConfig mongodbUri",mongodbUri);
//        //properties 对象为springboot创建，可直接用
//        String username = "smartnet";
//        String database = "liquidnet_mgdb";
//        String password = "a43ljKmK8oqdOO902P";
//        MongoCredential credentials = MongoCredential.createCredential(username, database, password.toCharArray());
//        String host = "smartnet-nonprod-docdb-docdb.cluster-cgjsqu7tuka2.ap-southeast-1.docdb.amazonaws.com";
//        int port = 27017;
//        List<ServerAddress> addrs = Collections.singletonList(new ServerAddress(host, port));
//
//        System.setProperty("javax.net.ssl.trustStore",trustStore);
//        System.setProperty("javax.net.ssl.trustStorePassword",trustStorePassword);
//        MongoClientOptions options = MongoClientOptions.builder()
//                .sslEnabled(true) //开启SSL连接
//                .sslInvalidHostNameAllowed(true) //不检查证书域名
//                .minConnectionsPerHost(1) //连接池最小连接数，最大连接数默认为100
//                .build();
//        return new MongoClient(addrs, credentials, options);
//    }
//
//    private MongoCredential getCredentials(MongoProperties properties) {
//        String username = properties.getUsername();
//        String database = properties.getAuthenticationDatabase() == null
//                ? properties.getMongoClientDatabase()
//                : properties.getAuthenticationDatabase();
//        //此处可将加密的密码解密，替换配置文件中的值
//        properties.setPassword(new String(properties.getPassword()).toCharArray());
//        char[] password = properties.getPassword();
//        return MongoCredential.createCredential(username, database, password);
//    }
}
