package com.liquidnet.service.adam.controller.admin.company;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.query.AdamComInfoQuery;
import com.liquidnet.service.adam.entity.AdamComInfo;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.IAdamComInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 后台公司信息 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
@Api(tags = "admin com info")
@Slf4j
@RestController
@RequestMapping("/admin/adam-com-info")
public class AdminAdamComInfoController {
    @Autowired
    private IAdamComInfoService adamComInfoService;

    @NoAuth
    @ApiOperation(value = "query_list")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.ADMIN)
    @GetMapping("/query_list")
    public ResponseDto<Page<AdamComInfo>> queryList(@RequestBody AdamComInfoQuery query,
                                                    @RequestParam int pageNum,
                                                    @RequestParam int pageSize) {
        ResponseDto<Page<AdamComInfo>> respDto = ResponseDto.success();
        try {
            Page<AdamComInfo> adamComInfoPage = adamComInfoService.queryPageList(pageNum, pageSize, query);

            respDto.setData(adamComInfoPage);
        } catch (Exception e) {
            log.error("queryList异常", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
        return respDto;
    }

}
