package com.liquidnet.service.adam.controller.admin.transaction;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.AdamTransactionDto;
import com.liquidnet.service.adam.dto.admin.transaction.*;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.admin.transaction.IAdminTransactionRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;

@Slf4j
@Api(tags = "ADMIN.TRANSACTION.API")
@RestController
@RequestMapping("/admin/adam-trans-query")
public class AdminTransactionQueryController {
    @Autowired
    private IAdminTransactionRecordService adminTransactionRecordService;

    @NoAuth
    @PostMapping("/rechargeList")
    @ApiOperation(value = "list admin trans-query rechargeList by condition")
    @ApiImplicitParams({
            @ApiImplicitParam(dataType = "int", type = "query", name = "pageNum", value = "页码"),
            @ApiImplicitParam(dataType = "int", type = "query", name = "pageSize", value = "每页显示条数")
    })
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.ADMIN)
    public ResponseDto<Page<AdamTransactionDto>> rechargeList(@RequestBody AdamRechargeRecordReq adamRechargeRecordReq,
                                                              @RequestParam(required = false, value = "pageNum", defaultValue = "1") Integer pageNum,
                                                              @RequestParam(required = false, value = "pageSize", defaultValue = "10") Integer pageSize,
                                                              HttpServletRequest request) {
        log.info("[ADMIN CLIENT REQUEST QUERY TRANSACTION LIST] at : {} and request param : {}",
                LocalDateTime.now(), JsonUtils.toJson(adamRechargeRecordReq));
        Page<AdamTransactionDto> listDataDto = adminTransactionRecordService.queryRechargePageList(pageNum, pageSize,
                adamRechargeRecordReq, null);
        return ResponseDto.success(listDataDto);
    }


    @NoAuth
    @PostMapping("/payoutList")
    @ApiOperation(value = "list admin trans-query payoutList by condition")
    @ApiImplicitParams({
            @ApiImplicitParam(dataType = "int", type = "query", name = "pageNum", value = "页码"),
            @ApiImplicitParam(dataType = "int", type = "query", name = "pageSize", value = "每页显示条数")
    })
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.ADMIN)
    public ResponseDto<Page<AdamTransactionDto>> payoutList(@RequestBody AdamPayoutRecordReq adamPayoutRecordReq,
                                                                  @RequestParam("pageNum") int pageNum,
                                                                  @RequestParam("pageSize") int pageSize,
                                                                  HttpServletRequest request) {
        log.info("[ADMIN CLIENT REQUEST QUERY TRANSACTION LIST] at : {} and request param : {}",
                LocalDateTime.now(), JsonUtils.toJson(adamPayoutRecordReq));
        Page<AdamTransactionDto> listDataDto = adminTransactionRecordService.queryPayoutPageList(pageNum, pageSize,
                adamPayoutRecordReq, null);
        return ResponseDto.success(listDataDto);
    }

    @NoAuth
    @GetMapping("/getPayoutDetailByOrderId")
    @ApiOperation(value = "list admin trans-query getPayoutDetailByOrderId by condition")
    @ApiImplicitParams({
            @ApiImplicitParam(dataType = "int", type = "query", name = "pageNum", value = "页码"),
            @ApiImplicitParam(dataType = "int", type = "query", name = "pageSize", value = "每页显示条数")
    })
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.ADMIN)
    public ResponseDto<AdamPayoutDetailDto> getPayoutDetailByOrderId(@RequestParam("orderId") String orderId) {
        log.info("[ADMIN CLIENT getPayoutDetailByOrderId] at : {} and request param : {}",LocalDateTime.now(), orderId);
        AdamPayoutDetailDto adamPayoutDetailDto = adminTransactionRecordService.getPayoutDetailByOrderId(orderId);
        return ResponseDto.success(adamPayoutDetailDto);
    }

    @NoAuth
    @PostMapping("/conversionList")
    @ApiOperation(value = "list admin trans-query conversionList by condition")
    @ApiImplicitParams({
            @ApiImplicitParam(dataType = "int", type = "query", name = "pageNum", value = "页码"),
            @ApiImplicitParam(dataType = "int", type = "query", name = "pageSize", value = "每页显示条数")
    })
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.ADMIN)
    public ResponseDto<Page<AdamTransactionDto>> conversionList(@RequestBody AdamConversionRecordReq adamConversionRecordReq,
                                                                  @RequestParam("pageNum") int pageNum,
                                                                  @RequestParam("pageSize") int pageSize,
                                                                  HttpServletRequest request) {
        log.info("[ADMIN CLIENT REQUEST QUERY TRANSACTION LIST] at : {} and request param : {}",
                LocalDateTime.now(), JsonUtils.toJson(adamConversionRecordReq));
        Page<AdamTransactionDto> listDataDto = adminTransactionRecordService.queryConversionPageList(pageNum, pageSize,
                adamConversionRecordReq, null);
        return ResponseDto.success(listDataDto);
    }
}
