package com.liquidnet.service.adam.controller.admin.user;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.query.AdamUserQuery;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.IAdamUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.time.LocalDateTime;

@Slf4j
@Api(tags = "ADMIN.USER.API")
@RestController
@RequestMapping("/admin/adam-user")
public class AdminAdamUserController {


    @Autowired
    private IAdamUserService adamUserService;

    @NoAuth
    @PostMapping("/list")
    @ApiOperation(value = "list adam user info by condition")
    @ApiImplicitParams({
            @ApiImplicitParam(dataType = "int", type = "query", name = "pageNum", value = "页码"),
            @ApiImplicitParam(dataType = "int", type = "query", name = "pageSize", value = "每页显示条数")
    })
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.ADMIN)
    public ResponseDto<Page<AdamUser>> listAdamUser(@RequestBody AdamUserQuery adamUserQuery,
                                                    @RequestParam("pageNum") int pageNum,
                                                    @RequestParam("pageSize") int pageSize) {
        log.info("[ADMIN CLIENT REQUEST QUERY ADAM USER LIST] at : {} and request param : {}",
                LocalDateTime.now(), JsonUtils.toJson(adamUserQuery));
        Page<AdamUser> listDataDto = adamUserService.queryPageList(pageNum, pageSize, adamUserQuery);
        return ResponseDto.success(listDataDto);
    }
}
