package com.liquidnet.service.adam.controller.api.company;

import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.constant.AdamComConstants;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.common.AdamErrorCode;
import com.liquidnet.service.adam.dto.AdamComInfoDto;
import com.liquidnet.service.adam.dto.AdamComInfoParam;
import com.liquidnet.service.adam.entity.AdamComInfo;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.IAdamComInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * 对外API接口
 *
 * @author LiChen
 * @date 2020/10/10 5:44 下午
 */
@Api(tags = "api com")
@Slf4j
@RestController
@RequestMapping("/api/adam-com")
public class ApiAdamComController {
    @Autowired
    private IAdamComInfoService adamComInfoService;

    @NoAuth
    @ApiOperation(value = "泰国审核后回调接口,公司状态激活")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.FEIGN)
    @PostMapping(value = "/notify_activated")
    public ResponseDto activeFinalSubmit(HttpServletRequest request,
                                         @RequestParam String comId) {
        log.info("api com notify activated,comId=[{}]", comId);
        // todo-lichen 未完成 暂时无签名验签,直接更改状态从7 未激活 到 8 已激活
        try {

            AdamComInfo adamComInfo = adamComInfoService.selectById(comId);
            if (adamComInfo == null) {
                return ResponseDto.failure(ErrorCode.ILLEGAL_ARGUMENT);
            }
            String state = adamComInfo.getState();
            if (AdamComConstants.ComStateEnum.S8.getCode().equals(state)) {
                return ResponseDto.success();
            }

            // 更新参数
            AdamComInfoDto updateDto = new AdamComInfoDto();
            updateDto.setState(AdamComConstants.ComStateEnum.S8.getCode());

            // 更新条件
            AdamComInfoParam updateParam = new AdamComInfoParam();
            updateParam.setId(comId);
            updateParam.setState(AdamComConstants.ComStateEnum.S7.getCode());
            int i = adamComInfoService.update(updateDto, updateParam);
            log.info("api com notify activated 更新行=[{}]", i);
            return i > 0 ? ResponseDto.success() : ResponseDto.failure(AdamErrorCode.ADAM001_ILLEGAL_OPERATION.getCode(), AdamErrorCode.ADAM001_ILLEGAL_OPERATION.getVal());

        } catch (Exception e) {
            log.error("api com notify activated异常", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
    }

}
