package com.liquidnet.service.adam.controller.feign.account;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.IAdamAccountApiService;
import com.liquidnet.service.adam.service.IAdamAccountService;
import com.liquidnet.service.adam.service.IAdamAccountWalletService;
import com.liquidnet.service.bank.currencycloud.entity.BankCcBalance;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * 对外API接口
 *
 * @author LiChen
 * @date 2020/10/10 5:44 下午
 */
@Api(tags = "feign account wallet")
@Slf4j
@RestController
@RequestMapping("/feign/adam-account-wallet")
public class FeignAdamAccountWalletController {

    @Autowired
    IAdamAccountWalletService adamAccountWalletService;

    @Autowired
    IAdamAccountService adamAccountService;

    @Autowired
    IAdamAccountApiService adamAccountApiService;

    @NoAuth
    @ApiOperation(value = "push notity bank cc balance")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.FEIGN)
    @PostMapping(value = "/push_notify_bank_cc_balance")
    public ResponseDto pushNotifyBalance(HttpServletRequest request,
                                     @RequestBody BankCcBalance balance) {
        String logFx = "api adam-account-wallet push notify balance.";
        log.info(logFx + "balance=[{}]", JSON.toJSONString(balance, SerializerFeature.WriteMapNullValue));
        try {
            AdamResultDto adamResultDto = adamAccountApiService.pushNotifyBankCcBalance(balance);
            log.info(logFx + "result=[{}]", JSON.toJSONString(adamResultDto, SerializerFeature.WriteMapNullValue));
            return null;
        } catch (Exception e) {
            log.error(logFx + "异常", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
    }

}
