package com.liquidnet.service.adam.controller.feign.conversion;

import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.IAdamConversionApiService;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@Api(tags = "feign conversion")
@Slf4j
@RestController
@RequestMapping("/feign/adam-conversion")
public class FeignAdamConversionController {

    @Autowired
    private IAdamConversionApiService adamConversionApiService;

    @NoAuth
    @ApiOperation(value = "push notify bank cc conversion")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.FEIGN)
    @PostMapping("/push_notify_bank_cc_conversion")
    public ResponseDto pushNotifyBankCcConversion(HttpServletRequest request,
                                                  @RequestBody BankCcConversionDto dto) {
        String logFx = "push notify bank cc conversion.";
        log.info(logFx + "BankCcConversionDto=[{}]", dto);
        ResponseDto responseDto;
        try {
            AdamResultDto adamResultDto = adamConversionApiService.bankCcConversion(dto);
            responseDto = AdamResultDto.getResponseDto(adamResultDto);

        } catch (Exception e) {
            log.error(logFx + "error", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
        return responseDto;
    }

}
