package com.liquidnet.service.adam.controller.feign.funding;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.IAdamFundingApiService;
import com.liquidnet.service.bank.currencycloud.entity.BankCcTransaction;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * 充值信息表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-30
 */
@Api(tags = "feign funding")
@Slf4j
@RestController
@RequestMapping("/feign/adam-funding")
public class FeignAdamFundingController {

    @Autowired
    private IAdamFundingApiService adamFundingApiService;

    @NoAuth
    @ApiOperation(value = "push notify bank cc funding")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.FEIGN)
    @PostMapping("/push_notify_bank_cc_funding")
    public ResponseDto pushNotifyBankCcFunding(HttpServletRequest request,
                                               @RequestBody BankCcTransaction funding) {
        String logFx = "push notify bank cc funding.";
        log.info(logFx + "BankCcTransaction=[{}]", funding);
        ResponseDto responseDto;
        try {
            AdamResultDto adamResultDto = adamFundingApiService.bankCcFunding(funding);
            responseDto = AdamResultDto.getResponseDto(adamResultDto);

        } catch (Exception e) {
            log.error(logFx + "error", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
        return responseDto;
    }

}
