package com.liquidnet.service.adam.controller.feign.payout;

import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.IAdamPayoutApiService;
import com.liquidnet.service.bank.currencycloud.entity.BankCcPayment;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@Api(tags = "feign payout")
@Slf4j
@RestController
@RequestMapping("/feign/adam-payout")
public class FeignAdamPayoutController {

    @Autowired
    private IAdamPayoutApiService adamPayoutApiService;

    @NoAuth
    @ApiOperation(value = "push notify bank cc payment")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.FEIGN)
    @PostMapping("/push_notify_bank_cc_payment")
    public ResponseDto pushNotifyBankCcPayment(HttpServletRequest request,
                                               @RequestBody BankCcPayment dto) {
        String logFx = "push notify bank cc payment.";
        log.info(logFx + "BankCcPayment=[{}]", dto);
        ResponseDto responseDto;
        try {
            AdamResultDto adamResultDto = adamPayoutApiService.bankCcPayout(dto);
            responseDto = AdamResultDto.getResponseDto(adamResultDto);

        } catch (Exception e) {
            log.error(logFx + "error", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
        return responseDto;
    }

}
