package com.liquidnet.service.adam.controller.task;

import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.IAdamConversionApiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "task conversion")
@Slf4j
@RestController
@RequestMapping("/task/adam-conversion")
public class TaskAdamConversionController {

    @Autowired
    private IAdamConversionApiService adamConversionApiService;

    @NoAuth
    @ApiOperation(value = "向用户发送换汇PDF邮件,每小时的05分和35分执行")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.TASK)
    @PostMapping("/send_confirm_task")
    public ResponseDto sendConfirmTask() {
        AdamResultDto resultDto = adamConversionApiService.sendConfirm2();
        return AdamResultDto.getResponseDto(resultDto);
    }

}
