package com.liquidnet.service.adam.controller.task;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.constant.AdamPayoutConstants;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.entity.AdamPayout;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.mapper.AdamPayoutMapper;
import com.liquidnet.service.adam.service.IAdamPayoutApiService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;

@Api(tags = "task payout")
@Slf4j
@RestController
@RequestMapping("/task/adam-payout")
public class TaskAdamPayoutController {

    @Autowired
    private IAdamPayoutApiService adamPayoutApiService;

    @Autowired
    private AdamPayoutMapper adamPayoutMapper;

    @Autowired
    private RedisUtil redisUtil;

    @NoAuth
    @ApiOperation(value = "每个工作日早7点,晚10点执行一次等待充值的下发")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.TASK)
    @PostMapping("/awaiting_funds_task")
    public ResponseDto awaitingFundsDoPayoutTask() {
        adamPayoutApiService.asyncAwaitingFundsDoPayout(null);
        return ResponseDto.success();
    }

    @NoAuth
    @ApiOperation(value = "execution date task")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.TASK)
    @PostMapping("/execution_date_task")
    public ResponseDto executionDateTask() {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String dateStr = LocalDate.now().format(fmt);

        QueryWrapper<AdamPayout> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(AdamPayout::getExecutionDate, dateStr)
                .eq(AdamPayout::getStatus, AdamPayoutConstants.StatusEnum.READY_TO_PROCESS.getCode())
                .eq(AdamPayout::getSpotForward, AdamPayoutConstants.SpotForwardEnum.FORWARD.getCode())

        ;
        List<AdamPayout> list = adamPayoutMapper.selectList(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return ResponseDto.failure("1", dateStr + ":没有预约下发");
        }

        for (AdamPayout adamPayout : list) {
            AdamResultDto adamResultDto = adamPayoutApiService.doPayout(adamPayout.getId());
            log.info("execution date task,payoutId=[{}],AdamResultDto=[{}]", adamPayout.getId(), JsonUtils.toJson(adamResultDto));
        }

        return ResponseDto.success();

    }

}
