package com.liquidnet.service.adam.controller.web.company;

import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.constant.AdamComConstants;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.base.AdamCurrentUser;
import com.liquidnet.service.adam.vo.AdamComEnumVo;
import com.liquidnet.service.adam.dto.AdamComInfoDto;
import com.liquidnet.service.adam.entity.AdamComInfo;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.IAdamComInfoService;
import com.liquidnet.service.adam.service.IAdamSysCountryService;
import com.liquidnet.service.adam.util.CurrentUserUtil;
import com.liquidnet.service.adam.util.EnumUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * 公司信息 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
@Api(tags = "web com info")
@Slf4j
@RestController
@RequestMapping("/adam-com-info")
public class AdamComInfoController {
    @Autowired
    private IAdamComInfoService adamComInfoService;

    @Autowired
    private IAdamSysCountryService sysCountryService;

    @NoAuth
    @ApiOperation(value = "enum list")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_0)
    @GetMapping("/enum_list")
    public ResponseDto<AdamComEnumVo> enumList() {
        AdamComEnumVo adamComEnumResp = new AdamComEnumVo();
        // 公司类型
        adamComEnumResp.setComTypeList(EnumUtil.getList(AdamComConstants.ComTypeEnum.values()));
        // 公司实体结构
        adamComEnumResp.setComEntityStructureList(EnumUtil.getList(AdamComConstants.ComEntityStructureEnum.values()));
        // 公司行业类别
        adamComEnumResp.setComIndustryCategoryList(EnumUtil.getList(AdamComConstants.ComIndustryCategoryEnum.values()));
        // 预计交易量
        adamComEnumResp.setComExpectedTransactionList(EnumUtil.getList(AdamComConstants.ComExpectedTransactionEnum.values()));
        // Liquidnet用途
        adamComEnumResp.setComLiquidnetUseList(EnumUtil.getList(AdamComConstants.ComLiquidnetUseEnum.values()));
        // 身份类型
        adamComEnumResp.setIdTypeList(EnumUtil.getList(AdamComConstants.IdTypeEnum.values()));
        // 国家/地区代码,电话代码
        adamComEnumResp.setSysCountryList(sysCountryService.selectList(null));
        return ResponseDto.success(adamComEnumResp);
    }

    @ApiOperation(value = "get com info")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_0)
    @GetMapping("/query")
    public ResponseDto<AdamComInfoDto> query(HttpServletRequest request) {
        ResponseDto<AdamComInfoDto> respDto = ResponseDto.success();
        try {
            AdamCurrentUser currentUser = CurrentUserUtil.getCurrentUser(request);
            AdamComInfo adamComInfo = adamComInfoService.selectById(currentUser.getComId());
            AdamComInfoDto dto = new AdamComInfoDto();
            BeanUtils.copyProperties(adamComInfo, dto);
            respDto.setData(dto);
        } catch (Exception e) {
            log.error("query异常", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
        return respDto;
    }

}
