package com.liquidnet.service.adam.controller.web.company;

import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.AdamComInfoExtendDto;
import com.liquidnet.service.adam.dto.base.AdamCurrentUser;
import com.liquidnet.service.adam.entity.AdamComInfoExtend;
import com.liquidnet.service.adam.service.IAdamComInfoExtendService;
import com.liquidnet.service.adam.util.CurrentUserUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * 公司信息扩展 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
@Api(tags = "web com info extend")
@Slf4j
@RestController
@RequestMapping("/adam-com-info-extend")
public class AdamComInfoExtendController {
    @Autowired
    private IAdamComInfoExtendService adamComInfoExtendService;

    @ApiOperation(value = "get com info extend")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_0)
    @GetMapping("/query")
    public ResponseDto<AdamComInfoExtendDto> query(HttpServletRequest request) {
        ResponseDto<AdamComInfoExtendDto> respDto = ResponseDto.success();
        try {
            AdamCurrentUser currentUser = CurrentUserUtil.getCurrentUser(request);
            AdamComInfoExtend adamComInfoExtend = adamComInfoExtendService.selectById(currentUser.getComId());
            AdamComInfoExtendDto dto = new AdamComInfoExtendDto();
            if(adamComInfoExtend !=null){
                BeanUtils.copyProperties(adamComInfoExtend, dto);
            }
            respDto.setData(dto);
        } catch (Exception e) {
            log.error("query异常", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
        return respDto;
    }


}
