package com.liquidnet.service.adam.controller.web.company;

import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.AdamComLegalPersonDto;
import com.liquidnet.service.adam.dto.base.AdamCurrentUser;
import com.liquidnet.service.adam.service.IAdamComLegalPersonService;
import com.liquidnet.service.adam.util.CurrentUserUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * 公司法人 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-25
 */
@Api(tags = "web com legal person")
@Slf4j
@RestController
@RequestMapping("/adam-com-legal-person")
public class AdamComLegalPersonController {
    @Autowired
    private IAdamComLegalPersonService adamComLegalPersonService;

    @ApiOperation(value = "get com Legal person")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_0)
    @GetMapping("/query")
    public ResponseDto<AdamComLegalPersonDto> query(HttpServletRequest request) {
        ResponseDto<AdamComLegalPersonDto> respDto = ResponseDto.success();
        try {
            AdamCurrentUser currentUser = CurrentUserUtil.getCurrentUser(request);
            AdamComLegalPersonDto dto = adamComLegalPersonService.selectByComId(currentUser.getComId());
            respDto.setData(dto);
        } catch (Exception e) {
            log.error("query异常", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
        return respDto;
    }

}
