package com.liquidnet.service.adam.controller.web.company;

import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.AdamComShareholderDto;
import com.liquidnet.service.adam.dto.base.AdamCurrentUser;
import com.liquidnet.service.adam.entity.AdamComShareholder;
import com.liquidnet.service.adam.service.IAdamComShareholderService;
import com.liquidnet.service.adam.util.CurrentUserUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 公司股东信息 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
@Api(tags = "web com shareholder")
@Slf4j
@RestController
@RequestMapping("/adam-com-shareholder")
public class AdamComShareholderController {
    @Autowired
    private IAdamComShareholderService adamComShareholderService;

    @ApiOperation(value = "get com shareholder")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_0)
    @GetMapping("/query")
    public ResponseDto<List<AdamComShareholderDto>> query(HttpServletRequest request) {
        ResponseDto<List<AdamComShareholderDto>> respDto = ResponseDto.success();
        try {
            AdamCurrentUser currentUser = CurrentUserUtil.getCurrentUser(request);
            List<AdamComShareholder> list = adamComShareholderService.selectByComId(currentUser.getComId());
            List<AdamComShareholderDto> dtoList = list.stream()
                    .map(e -> {
                        AdamComShareholderDto d = new AdamComShareholderDto();
                        BeanUtils.copyProperties(e, d);
                        return d;
                    })
                    .collect(Collectors.toList());
            respDto.setData(dtoList);
        } catch (Exception e) {
            log.error("query异常", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
        return respDto;
    }


}
