package com.liquidnet.service.adam.controller.web.company;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.AdamComFilesDto;
import com.liquidnet.service.adam.dto.base.AdamCurrentUser;
import com.liquidnet.service.adam.entity.AdamComInfoExtend;
import com.liquidnet.service.adam.entity.AdamCountryFileLink;
import com.liquidnet.service.adam.service.IAdamComInfoExtendService;
import com.liquidnet.service.adam.service.IAdamCountryFileLinkService;
import com.liquidnet.service.adam.util.CurrentUserUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 注册国家关联文件表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-24
 */
@Api(tags = "web com country file link")
@Slf4j
@RestController
@RequestMapping("/adam-country-file-link")
public class AdamCountryFileLinkController {

    @Autowired
    private IAdamCountryFileLinkService adamCountryFileLinkService;

    @Autowired
    private IAdamComInfoExtendService adamComInfoExtendService;

    @ApiOperation(value = "get country file link")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_0)
    @ApiImplicitParams({
            @ApiImplicitParam(type = "path", dataType = "String", name = "countryCode", value = "country code")
    })
    @GetMapping("/query/{countryCode}")
    public ResponseDto<List<AdamComFilesDto>> query(HttpServletRequest request, @PathVariable("countryCode") String countryCode) {
        ResponseDto<List<AdamComFilesDto>> respDto = ResponseDto.success();
        try {
            List<AdamComFilesDto> filesDtoList = new ArrayList<>();

            AdamCurrentUser currentUser = CurrentUserUtil.getCurrentUser(request);
            AdamComInfoExtend adamComInfoExtend = adamComInfoExtendService.selectByCountryCode(currentUser.getComId(), countryCode);
            if (adamComInfoExtend != null && !StringUtils.isEmpty(adamComInfoExtend.getFiles())) {
                try {
                    filesDtoList = JSONArray.parseArray(adamComInfoExtend.getFiles(), AdamComFilesDto.class);
                } catch (Exception e) {
                    log.warn("file json parsing failed,comId:[{}],countryCode:[{}]", currentUser.getComId(), countryCode);
                }
            }

            if (CollectionUtils.isEmpty(filesDtoList)) {
                List<AdamCountryFileLink> fileLinkList = adamCountryFileLinkService.selectByCountryCode(countryCode);
                for (AdamCountryFileLink fileLink : fileLinkList) {
                    AdamComFilesDto dto = new AdamComFilesDto();
                    dto.setFileId(fileLink.getFileId());
                    dto.setFileAliasTitle(fileLink.getFileAliasTitle());
                    dto.setList(Lists.newArrayList());
                    filesDtoList.add(dto);

                }
            }
            respDto.setData(filesDtoList);

        } catch (Exception e) {
            log.error("query异常", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
        return respDto;
    }

}
