package com.liquidnet.service.adam.controller.web.dashboard;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.account.common.FinConstants;
import com.liquidnet.service.account.common.FinConstants.Dashboard.Chart;
import com.liquidnet.service.account.wallet.dto.WalletDashboardParam;
import com.liquidnet.service.account.wallet.vo.WalletDashboardInfoVo;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.constant.AdamDashboardConstants;
import com.liquidnet.service.adam.constant.AdamTransactionConstants;
import com.liquidnet.service.adam.dto.base.AdamCurrentUser;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.IAdamDashboardService;
import com.liquidnet.service.adam.service.IAdamTransactionService;
import com.liquidnet.service.adam.service.feign.fin.IAdamFeignAccountService;
import com.liquidnet.service.adam.util.CurrentUserUtil;
import com.liquidnet.service.adam.util.EnumUtil;
import com.liquidnet.service.adam.vo.AdamBeneficiaryEnumVo;
import com.liquidnet.service.adam.vo.AdamDashboardEnumVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 公司账户 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-13
 */
@Api(tags = "web dashboard")
@Slf4j
@RestController
@RequestMapping("/adam-dashboard")
public class AdamDashboardController {

    @Autowired
    private IAdamFeignAccountService adamFeignAccountService;

    @Autowired
    private IAdamDashboardService adamDashboardService;

    @Autowired
    private IAdamTransactionService adamTransactionService;

    @NoAuth
    @ApiOperation(value = "enum list")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_1)
    @GetMapping("/enum_list")
    public ResponseDto<AdamDashboardEnumVo> enumList() {
        AdamDashboardEnumVo vo = new AdamDashboardEnumVo();
        vo.setPeriodList(EnumUtil.getList(AdamDashboardConstants.PeriodEnum.values()));
        vo.setTransactionStatusList(EnumUtil.getList(AdamTransactionConstants.StatusEnum.values()));
        vo.setBalanceTypeList(EnumUtil.getList(AdamDashboardConstants.BalanceTypeEnum.values()));

        return ResponseDto.success(vo);
    }

    @NoAuth
    @ApiOperation(value = "Summary of Wallets Balance")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_1)
    @GetMapping("/summary_wallet_balance")
    public ResponseDto<AdamBeneficiaryEnumVo> summaryOfWalletsBalance(
            @RequestParam String finWalletNo,
            @RequestParam String period,
            @RequestParam(required = false) FinConstants.Dashboard.Balance[] balances) {

        WalletDashboardParam param = new WalletDashboardParam();
        param.setWalletNo(finWalletNo);
        param.setDashboardPeriod(AdamDashboardConstants.PeriodEnum.getFinPerid(period));
        param.setDashboardChart(Chart.Wallet_Balance);
        if (balances == null) {
            balances = new FinConstants.Dashboard.Balance[]{FinConstants.Dashboard.Balance.All};
        }
        param.setDashboardBalance(balances);
        AdamResultDto<Map<String, List<WalletDashboardInfoVo>>> mapAdamResultDto = adamFeignAccountService.dashboardShow(param);
        return AdamResultDto.getResponseDto(mapAdamResultDto);
    }

    @NoAuth
    @ApiOperation(value = "Summary of Wallets Transaction")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_1)
    @GetMapping("/summary_wallet_transaction")
    public ResponseDto<Map<String, Map<String, Map<String, String>>>> summaryOfWalletsTransaction(@RequestParam String finWalletNo,
                                                                                       @RequestParam String period,
                                                                                       @RequestParam(required = false) String[] transactionStatusEnums) {
        Map<String, Map<String, Map<String, String>>> stringListMap = adamDashboardService.summaryOfWalletsTransaction(finWalletNo, period, transactionStatusEnums);

        return ResponseDto.success(stringListMap);
    }

    @ApiOperation(value = "Summary of Transactions")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_1)
    @GetMapping("/summary_transactions")
    public ResponseDto<Map<String, String>> summaryOfTransactions(@RequestParam String period, HttpServletRequest request) {
        AdamCurrentUser currentUser = CurrentUserUtil.getCurrentUser(request);
        String comId = currentUser.getComId();
        Map<String, String> stringMap = adamDashboardService.summaryOfTransactions(comId, period);
        return ResponseDto.success(stringMap);
    }

}
