package com.liquidnet.service.adam.controller.web.payout;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.AdamPayoutDetailDto;
import com.liquidnet.service.adam.dto.AdamPayoutDetailParam;
import com.liquidnet.service.adam.dto.base.AdamCurrentUser;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.entity.AdamPayout;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.interceptor.annotation.RequiresPermissions;
import com.liquidnet.service.adam.service.IAdamPayoutApiService;
import com.liquidnet.service.adam.util.CurrentUserUtil;
import com.liquidnet.service.adam.vo.AdamPayoutVo;
import com.liquidnet.service.bank.currencycloud.entity.BankCcPayment;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

@Api(tags = "web payout")
@Slf4j
@RestController
@RequestMapping("/adam-payout")
public class AdamPayoutController {

    @Autowired
    private IAdamPayoutApiService adamPayoutApiService;

    @RequiresPermissions("7D53AE2D")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_1)
    @ApiOperation(value = "create payout")
    @PostMapping(value = "/create")
    public ResponseDto<AdamPayoutVo> create(@RequestBody AdamPayoutDetailParam createParam,
                                            HttpServletRequest request) {
        String logFx = "create payout.";
        try {
            AdamCurrentUser currentUser = CurrentUserUtil.getCurrentUser(request);
            log.info(logFx + "comId=[{}],createParam=[{}]", currentUser.getComId(), JSON.toJSONString(createParam, SerializerFeature.WriteMapNullValue));
            createParam.getPayout().setComId(currentUser.getComId());
            createParam.getPayout().setUserId(currentUser.getId());
            AdamResultDto<AdamPayoutDetailDto> busDto = adamPayoutApiService.createPayout(createParam);
            if (busDto.isSuccess()) {
                AdamPayoutVo vo = new AdamPayoutVo();
                AdamPayoutDetailDto data = busDto.getData();
                AdamPayout adamPayout = data.getAdamPayout();
                vo.conversion(adamPayout);
                vo.setTransactionId(data.getTransaction().getId());
                return ResponseDto.success(vo);
            }
            return AdamResultDto.getResponseDto(busDto);
        } catch (Exception e) {
            log.error(logFx + "error", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
    }

    @RequiresPermissions("7D53AE2D")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_1)
    @ApiOperation(value = "cancelled payout")
    @PostMapping(value = "/cancelled")
    public ResponseDto cancelled(@RequestParam String payoutId,
                                 HttpServletRequest request) {
        String logFx = "cancelled payout.payoutId=[" + payoutId + "]";
        try {
            AdamCurrentUser currentUser = CurrentUserUtil.getCurrentUser(request);
            String comId = currentUser.getComId();
            AdamResultDto paymentOrTask = adamPayoutApiService.cancelledPayout(comId, payoutId);
            ResponseDto responseDto = AdamResultDto.getResponseDto(paymentOrTask);
            return responseDto;
        } catch (Exception e) {
            log.error(logFx + "error", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
    }

    @RequiresPermissions("7D53AE2D")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_1)
    @ApiOperation(value = "edit payout")
    @PostMapping(value = "/edit")
    public ResponseDto<AdamPayoutVo> edit(@RequestBody AdamPayoutDetailParam editParam,
                                          HttpServletRequest request) {
        String logFx = "edit payout.";
        try {
            AdamCurrentUser currentUser = CurrentUserUtil.getCurrentUser(request);
            String comId = currentUser.getComId();
            editParam.getPayout().setComId(comId);
            log.info(logFx + "comId=[{}],editParam=[{}]", currentUser.getComId(), JsonUtils.toJson(editParam));
            AdamResultDto<AdamPayoutDetailDto> busDto = adamPayoutApiService.editPayout(editParam);

            if (busDto.isSuccess()) {
                AdamPayoutVo vo = new AdamPayoutVo();
                AdamPayoutDetailDto data = busDto.getData();
                AdamPayout adamPayout = data.getAdamPayout();
                vo.conversion(adamPayout);
                vo.setTransactionId(data.getTransaction().getId());
                return ResponseDto.success(vo);
            }

            ResponseDto responseDto = AdamResultDto.getResponseDto(busDto);
            return responseDto;
        } catch (Exception e) {
            log.error(logFx + "error", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
    }

    @NoAuth
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_1)
    @ApiOperation(value = "test payout")
    @PostMapping(value = "/test")
    public ResponseDto test(@RequestParam String payoutId) {
        try {

//            adamPayoutApiService.asyncFundingDoPayout("11560000002");
//            return ResponseDto.success();
            AdamResultDto<BankCcPayment> payment = adamPayoutApiService.doPayout(payoutId);

            return AdamResultDto.getResponseDto(payment);

        } catch (Exception e) {
            log.error("test payout error", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }

    }

}
