package com.liquidnet.service.adam.controller.web.sys;

import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.time.ZoneOffset;

@Slf4j
@Api(tags = "web sys")
@RestController
@RequestMapping("/adam-sys")
public class AdamSysController {
    @NoAuth
    @ApiOperation(value = "获取服务器的当前时间")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_SYS)
    @GetMapping("/get_unix_timestamp")
    public ResponseDto getUnixTimestamp() {
//        String format = DateUtil.format(LocalDateTime.now(), DateUtil.Formatter.english);
        long milliseconds = LocalDateTime.now().toInstant(ZoneOffset.UTC).toEpochMilli();
        return ResponseDto.success(milliseconds);
    }

    @NoAuth
    @ApiOperation(value = "UTC时间戳转换前端显示的英文格式时间")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_SYS)
    @GetMapping("/get_english_time")
    public ResponseDto getEnglishTime(@RequestParam(required = false) String timeStamp) {
        LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC);
        if (!StringUtils.isEmpty(timeStamp)) {
            if (timeStamp.length() == 10) {
                localDateTime = LocalDateTime.ofEpochSecond(Long.parseLong(timeStamp), 0, ZoneOffset.UTC);
            } else if (timeStamp.length() == 13) {
                localDateTime = LocalDateTime.ofEpochSecond(Long.parseLong(timeStamp) / 1000, 0, ZoneOffset.UTC);
            }
        }
        String format = DateUtil.format(localDateTime, DateUtil.Formatter.english);
        return ResponseDto.success(format);
    }

}
