package com.liquidnet.service.adam.controller.web.sys;

import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.entity.AdamSysCountry;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.IAdamSysCountryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 国家表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-24
 */
@Api(tags = "web sys country")
@RestController
@RequestMapping("/adam-sys-country")
public class AdamSysCountryController {

    @Autowired
    private IAdamSysCountryService sysCountryService;

    @NoAuth
    @ApiOperation(value = "国家代码")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_SYS)
    @GetMapping("/list_country")
    public ResponseDto<List<AdamSysCountry>> listCountry() {

        // 国家/地区代码,电话代码
        List<AdamSysCountry> sysCountryList = sysCountryService.selectList(null);
        return ResponseDto.success(sysCountryList);

    }

}
